local SGCommon = require "stategraphs.sg_common"
local SGPlayerCommon = require "stategraphs.sg_player_common"
local fmodtable = require "defs.sound.fmodtable"
local PlayerSkillState = require "playerskillstate"

local events = {}

local states =
{
	PlayerSkillState({
		name = "skill_polearm_vault",
		tags = { "busy" },

		onenter = function(inst)
			inst.AnimState:PlayAnimation("polearm_skill_vault_pre")
		end,

		timeline =
		{
			-- Physics
			-- Code Generated by PivotTrack.jsfl
			FrameEvent(5, function(inst) inst.Physics:MoveRelFacing(31/150) end),
			FrameEvent(7, function(inst) inst.Physics:MoveRelFacing(69/150) end),
			FrameEvent(14, function(inst) inst.Physics:MoveRelFacing(297/150) end),
			FrameEvent(16, function(inst) inst.Physics:MoveRelFacing(297/150) end),
			-- Code Generated by PivotTrack.jsfl

			FrameEvent(7, function(inst)
				inst.AnimState:SetSymbolFG("weapon_back01", true)
				inst.Physics:StartPassingThroughObjects()
			end),

			FrameEvent(14, function(inst)
				inst.sg:AddStateTag("airborne_high")
				inst.sg:AddStateTag("airborne")
				SGCommon.Fns.StartJumpingOverHoles(inst)
			end),
		},

		events =
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("skill_polearm_vault_pst")
			end),
		},

		onexit = function(inst)
			inst.AnimState:SetSymbolFG("weapon_back01", false)
			SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
			SGCommon.Fns.StopJumpingOverHoles(inst)
		end,
	}),

	PlayerSkillState({
		name = "skill_polearm_vault_pst",
		tags = { "busy", "airborne", "airborne_high" },

		onenter = function(inst)
			inst:FlipFacingAndRotation()
			inst.AnimState:PlayAnimation("polearm_skill_vault_pst")
			inst.Physics:StartPassingThroughObjects()
		end,

		timeline =
		{
			-- Physics
			-- Code Generated by PivotTrack.jsfl
			FrameEvent(2, function(inst) inst.Physics:MoveRelFacing(-290/150) end),
			FrameEvent(4, function(inst) inst.Physics:MoveRelFacing(-291/150) end),
			FrameEvent(6, function(inst) inst.Physics:MoveRelFacing(-290/150) end),
			-- End Generated Code

			FrameEvent(6, function(inst)
				inst.sg:RemoveStateTag("airborne_high")
			end),

			FrameEvent(8, function(inst)
				inst.sg:RemoveStateTag("airborne")
				SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
				SGPlayerCommon.Fns.SetCanDodge(inst)
			end),
			FrameEvent(13, SGPlayerCommon.Fns.RemoveBusyState),
		},

		events =
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle")
			end),
		},

		onexit = function(inst)
		end,
	}),
}

return StateGraph("sg_player_skill_polearm_vault", states, events, "skill_polearm_vault")
